#include <iostream>
#include <string>
#include <cstdlib>
#include <cstdio>
#include <algorithm>
#include <map>
#include <set>
#include <vector>
#include <cmath>
#include <cstring>
#include <queue>
#include <deque>
#include <functional>

#define mp make_pair
#define mt(a, b, c) mp(a, mp(b, c))
#define ABS(a) (((a) > 0) ? (a) : (-(a)))
#define ZERO(x) memset((x), 0, sizeof(x))
#define X first
#define Y second

using namespace std;
typedef long long ll;
typedef unsigned long long ull;

const int N = 100500;
const double EPS = 1e-7;

struct flower
{
	int vw, pf, vf, th;
	flower()
	{
		vw = pf = vf = th = 0;
	}

	flower(int _vw, int _pf, int _vf, int _th)
	{
		vw = _vw;
		pf = _pf;
		vf = _vf;
		th = _th;
	}
};

int n, water_cost;
flower garden[N];
int main()
{
	freopen("input.txt", "r", stdin);
	freopen("output.txt", "w", stdout);
	
	while (true)
	{
		cin >> n;
		if (n == 0)
			break;
		cin >> water_cost;
		double cost = 0.0;
		double coeff = 0.0;

		priority_queue<pair<double, double>, vector<pair<double, double> >, greater<pair<double, double> > > evn;
		for (int i = 0; i < n; i++)
		{
			cin >> garden[i].vw >> garden[i].pf >> garden[i].vf >> garden[i].th;
			double init_f = (garden[i].th + 0.0) / garden[i].vf * garden[i].pf;
			double water_p = (garden[i].vw + 0.0) / garden[i].vf * garden[i].pf;
			cost += max(init_f, 0.0);
			if (init_f + EPS > 0.0)
			{
				coeff += water_p;
			}
			
			double thr = (garden[i].th + 0.0) / garden[i].vw;
			if (thr > 0)
			{
				evn.push(mp(thr, ABS(water_p)));
			}
		}

		double min_cost = cost;
		double cur_w = 0.0;
		while (!evn.empty())
		{
			pair<double, double> evt = evn.top();
			evn.pop();
			double dw = evt.first - cur_w;
			cur_w = evt.first;
			cost += dw * (water_cost - coeff);
			coeff -= evt.second;
			if (min_cost > cost)
			{
				min_cost = cost;
			}
		}

		printf("%.10lf\n", min_cost);

	}
	return 0;
}